const express = require("express");
const router = express.Router();
const infoController = require("../controllers/infocontroller");
const authController = require("../controllers/authController");
const checkApiKey = require("../utils/checkApiKey");

// Public Routes

router.route("/").get(checkApiKey, infoController.getInfo);

// Protect all routes after this middleware
router.use(authController.protect);
router.use(authController.restrictTo("admin", "super-admin"));

// Create Info (POST /api/info)
router.route("/").post(infoController.createInfo);

// Routes for '/:id' (Update/Delete)
router
  .route("/:id")
  .patch(infoController.updateInfo) // Using PATCH is standard for partial updates
  .delete(infoController.deleteInfo);

module.exports = router;
